#pragma once
#include "afxwin.h"
#include "afxcmn.h"
#include "Infopage.h"
#include "Encoding.h"
#include "DriverSettings1.h"
#include "DriverSettings2.h"
#include "PrintDemo.h"
#include "UtilsPage.h"

/////////////////////////////////////////////////////////////////////////////

// CPrinterSettings dialog

class CPrinterSettings : public CPropertyPage
{
	DECLARE_DYNAMIC(CPrinterSettings)

public:
	CPrinterSettings();
	virtual ~CPrinterSettings();
	virtual BOOL OnInitDialog();
	static CString SmartModeString(ID_SMARTMODE Mode);

// Dialog Data
	enum { IDD = IDD_PRINTERPAGE };

protected:
	virtual void DoDataExchange(CDataExchange* pDX);    // DDX/DDV support

	DECLARE_MESSAGE_MAP()
	afx_msg void OnBnClickedBtnOpenSession();
	afx_msg void OnBnClickedBtnCloseSession();
	afx_msg void OnBnClickedBtnGetVersion();
	afx_msg void OnBnClickedBtnConnectionType();
	afx_msg void OnBnClickedBtnFeedMoveCard();
	afx_msg void FeedCard();
	afx_msg void MoveCard();
	afx_msg void OnBnClickedBtnMoveFilm();
	afx_msg void OnBtnClickedEjectCard();
	afx_msg void OnBnClickedBtnFlipCard();
	afx_msg void OnBnClickedBtnPrintTestCard();
	afx_msg void OnBnClickedBtnCleanPrinter();
	afx_msg void OnBnClickedBtnRestartPrinter();
	afx_msg void OnBtnClickedGeneralCmd();
	afx_msg void OnBnClickedBtnEraseCard();
	afx_msg void OnBnClickedBtnEraseSpeed();
	afx_msg void OnBnClickedBtnErrorResponse();
	afx_msg void OnBnClickedBtnHorzEject();
	afx_msg void OnBnClickedBtnEjectMode();
	afx_msg void OnBnClickedBtnSmartMode();
	afx_msg void OnBnClickedBtnSmartOffset();
	afx_msg void OnBnClickedGetActionRadio();
	afx_msg void OnBnClickedSetActionRadio();
	afx_msg void OnBnClickedBtnIPSettings();
	afx_msg void OnBnClickedBtnHandFeed();
	afx_msg void OnBnClickedBtnGeneralMsgClr();
	afx_msg void OnBnClickedBtnCardLocation();
	afx_msg void OnBnClickedBtnDocProps();

private:
	CMainSheet *Parent;

	CInfoPage        *InfoPage;
	CEncoding        *EncodingPage;
	CDriverSettings1 *DriverPage1;
	CDriverSettings2 *DriverPage2;
	CPrintDemo       *PrintPage;
	CUtilsPage       *UtilsPage;

	int PrinterAction;

	CEdit GeneralMsg;
	CComboBox FeedMoveCombo;
	CComboBox MoveFilmCombo;
	CComboBox EjectModeCombo;
	CComboBox SmartModeCombo;
	CEdit SmartOffset;
	CComboBox EraseSpeedCombo;
	CComboBox ErrorRespCombo;
	CButton OpenSessionBtn;
	CComboBox OpenSessionCombo;
	CButton CloseSessionBtn;
	CButton FeedMoveBtn;
	CButton MoveFilmBtn;
	CButton EjectCardBtn;
	CButton FlipCardBtn;
	CButton TestCardBtn;
	CButton CleanBtn;
	CButton RestartBtn;
	CStatic GenCmdGroupBox;
	CButton GenCmdBtn;
	CEdit GenCommandBox;
	CEdit EraseAreaBotLX;
	CEdit EraseAreaBotLY;
	CEdit EraseAreaTopRX;
	CEdit EraseAreaTopRY;
	CEdit EraseCount;
	CSpinButtonCtrl EraseCount_Spin;
	CButton EraseCardBtn;
	CButton EraseSpeedBtn;
	CButton ErrorRespBtn;
	CSpinButtonCtrl SmartOffset_Spin;
	CEdit GeneralMessage;
	CButton HorzEjectBtn;
	CComboBox HorzEjectCombo;
	CButton EjectModeBtn;
	CButton SmartModeBtn;
	CButton SmartOffsetBtn;
	CStatic IPGroupBox;
	CStatic IPModeLabel;
	CComboBox IPModeCombo;
	CStatic IPAddressLabel;
	CIPAddressCtrl IPAddress;
	CStatic IPSubnetLabel;
	CIPAddressCtrl IPSubnet;
	CStatic IPGatewayLabel;
	CIPAddressCtrl IPGateway;
	CButton IPSettingsBtn;
	CButton HandFeedBtn;
	CComboBox HandFeedCombo;
	CButton PrinterGet;
	CButton PrinterSet;
	CStatic Version;
	CButton CardLocationBtn;

	void AddGeneralMessage(CString pMessage);
	void ShowHideControls();
	void EnableGetSetControls(BOOL bControl);
	void EnableControls(BOOL bControl);
	void InitialisePerPrinter();
	int  GetPrinterModel();
	BOOL ProntoPrinter();
	BYTE SDKBits();
	BOOL PrinterConnected();

	void HandFeedToMsgBox(DWORD HandFeed, ID_READWRITE Action);
	void SetHandFeedBox(DWORD HandFeed);
	ID_RETURN GetHandFeed(PID_HANDFEED HandFeed);

	void EjectModeToMsgBox(ID_EJECTMODE EjectMode, ID_READWRITE Action);
	void SetEjectModeBox(ID_EJECTMODE EjectMode);
	ID_RETURN GetEjectMode(PID_EJECTMODE EjectMode);

	void HorzEjectToMsgBox(ID_HORZEJECT HorzEject, ID_READWRITE Action);
	void SetHorzEjectBox(ID_HORZEJECT HorzEject);
	ID_RETURN GetHorzEjectMode(PID_HORZEJECT Mode);

	void SmartModeToMsgBox(ID_SMARTMODE SmartMode, ID_READWRITE Action);
	void SetSmartModeBox(ID_SMARTMODE SmartMode);
	ID_RETURN GetSmartMode(PID_SMARTMODE Mode);

	void SmartOffsetToMsgBox(int Offset, ID_READWRITE Action);
	void SetSmartOffsetBox(int Offset);
	ID_RETURN GetSmartOffset(BYTE *Offset);

	void EraseSpeedToMsgBox(ID_ERASESPEED EraseSpeed, ID_READWRITE Action);
	void SetEraseSpeedBox(ID_ERASESPEED EraseSpeed);
	ID_RETURN GetEraseSpeed(PID_ERASESPEED Speed);

	void IPSettingsToMsgBox(PIPDATA pIPData, ID_READWRITE Action);
	ID_RETURN GetIPSettings(PIPDATA pIPData);

	ID_RETURN GetConnectionType();

	BOOL ActionIsGet();
};
